function Results=Optimization(Data,p,model,diff,MaxIter)
%This function determines the optimal parameter estimates
%Input
%Data               structure array with data
%p                  dimensionality
%model              type of model
%                   The variable model specifies which model should be used
%                   1=main Effects only model
%                   2=one-dimensional OSI model
%                   3=general multi-dimensional OSI model (equation (9) in
%                   Van Rosmalen, Koning, and Groenen (forthcoming))
%                   4=restricted multi-dimensional OSI model (equation (11) in
%                   Van Rosmalen, Koning, and Groenen (forthcoming))
%                   5=restricted multi-dimensional OSI model (equation (12) in
%                   Van Rosmalen, Koning, and Groenen (forthcoming))
%                   6=restricted multi-dimensional OSI model (equation (13) in
%                   Van Rosmalen, Koning, and Groenen (forthcoming))
%                   7=Full two-way interaction model
%MaxIter            maximum number of iterations in optimization routine
%diff               Boolean variable indicating whether analytical derivatives are used
%The output is the structure array Results
y=Data.y;
[n,m]=size(Data.Dat);
G=cell(m,1);
Y=cell(m,1);
A=cell(m,1);
MainEffects=cell(m,1);
k=zeros(m,1);
for j=1:m
    G{j}=indicator(Data.Dat(:,j));
    k(j)=size(G{j},2);
    A{j}=((sum(G{j})'*ones(1,k(j)-1))/n).^-1.*[eye(k(j)-1);-ones(1,k(j)-1)];
end
if model==1
    Z=0.1*randn(sum(k)-m+1,1);
elseif model==2 || model==4
    Z=0.1*randn((p+1)*(sum(k)-m)+1+0.5*m*(m-1),1);
elseif model==3
    Z=0.1*randn((p+1)*(sum(k)-m)+1+0.5*p*m*(m-1),1);
elseif model==5
    Z=0.1*randn((p+1)*(sum(k)-m)+1+p,1);
elseif model==6
    Z=0.1*randn((p+1)*(sum(k)-m)+1,1);
elseif model==7
    Z=0.01*randn(0.5*(sum(k-1)^2-sum((k-1).^2))+1+sum(k)-m,1);
end
if diff
    options = optimset('Diagnostics','off','LargeScale','off','Display','none',...
        'MaxIter',MaxIter,'MaxFunEvals',1000000,'TolX',0,'Tolfun',0,'GradObj','on','Hessian','off');
else
    options = optimset('Diagnostics','off','LargeScale','off','Display','none',...
        'MaxIter',MaxIter,'MaxFunEvals',1000000,'Tolfun',0,'TolX',0);
end
[Z,devValue]=fminunc(@Deviance,Z,options,p,Data.dist,Data.link,n,m,Data.V,... %The actual optimization using fminunc
    A,k,y,G,model);
c=Z(1);
index=2;
for j=1:m
    MainEffects{j}=A{j}*Z(index:index+k(j)-2);
    index=index+k(j)-1;
end
if model==1
    Y=[];
elseif model==7
    for i=1:m
        for j=1:m
            if i<j
                if Data.V(i,j)
                    Y{i,j}=Z(index:index+(k(i)-1)*(k(j)-1)-1);
                    Y{i,j}=A{i}*reshape(Y{i,j},[k(i)-1 k(j)-1])*A{j}';
                else
                    Y{i,j}=zeros(k(i),k(j));
                end
                index=index+(k(i)-1)*(k(j)-1);
            end
        end
    end
else
    for j=1:m
        for z=1:p
            Y{j}(:,z)=A{j}*Z(index:index+k(j)-2);
            index=index+k(j)-1;
        end
    end
    if model==2 || model==4
        S=zeros(m);
        for i=1:m
            for j=i+1:m
                S(i,j)=Z(index);
                index=index+1;
            end
        end
        S=(S+S');
        S(Data.V==0)=0;
        for i=1:m
            squaresum=(sumsqr(G{i}*Y{i})/n)^.5;
            S(i,:)=S(i,:)*squaresum;
            S(:,i)=S(:,i)*squaresum;
            Y{i}=Y{i}/squaresum;
        end
        maxs=-Inf;
        maxi=0;
        for i=0:2^m
            s=dec2bin(i,m);
            S_temp=S;
            for l=1:m
                S_temp(l,:)=S_temp(l,:)*2*(str2num(s(l))-0.5);
                S_temp(:,l)=S_temp(:,l)*2*(str2num(s(l))-0.5);
            end
            if squeeze(sum(sum(S_temp,1),2))>maxs
                maxs=squeeze(sum(sum(S_temp,1),2));
                maxi=i;
            end
        end
        i=maxi;
        s=dec2bin(i,m);
        for l=1:m
            S(l,:)=S(l,:)*2*(str2num(s(l))-0.5);
            S(:,l)=S(:,l)*2*(str2num(s(l))-0.5);
            Y{l}(:,:)=Y{l}(:,:)*2*(str2num(s(l))-0.5);
        end
        if p>1
            %Set rotation constraints
            YtY=zeros(p);
            for i=1:m
                YtY=YtY+(G{i}*Y{i})'*(G{i}*Y{i});
            end
            [Q,D]=eig(YtY);
            for i=1:m
                Y{i}=(inv(Q)*Y{i}')';
            end
            for z=1:p
                if Y{1}(1,z)>0
                    for i=1:m
                        Y{i}(:,z)=-1*Y{i}(:,z);
                    end
                end
            end
            %Re-order dimensions
            sumQj=0;
            for j=1:m
                sumQj=sumQj+(G{j}*Y{j})'*(G{j}*Y{j});
            end
            [sumQj,dimOrder]=sort(diag(-sumQj));
            Yt=Y;
            for l=1:p
                for j=1:m
                    Yt{j}(:,dimOrder(l))=Y{j}(:,l);
                end
            end
            Y=Yt;
        end
        %Invert signs if necessary, so that first category of first variable
        %has positive quantifications
        if Y{1}(1,1)<0
            for j=1:m
                Y{j}=-Y{j};
            end
        end
    elseif model==3
        S=zeros(m,m,p);
        for i=1:m
            for j=i+1:m
                if Data.V(i,j)
                    for l=1:p
                        S(i,j,l)=Z(index);
                        index=index+1;
                    end
                end
            end
        end
        for i=1:p
            S(:,:,i)=S(:,:,i)+S(:,:,i)';
        end
        for i=1:m
            for j=1:p
                squaresum=(sumsqr(Y{i}(:,j))/size(Y{i},1))^0.5;
                S(i,:,j)=S(i,:,j)*squaresum;
                S(:,i,j)=S(:,i,j)*squaresum;
                Y{i}(:,j)=Y{i}(:,j)/squaresum;
            end
        end
        for j=1:p
            maxs=-Inf;
            maxi=0;
            for i=1:2^m
                s=dec2bin(i,m);
                S_temp=S;
                for l=1:m
                    S_temp(l,:,j)=S_temp(l,:,j)*2*(str2num(s(l))-0.5);
                    S_temp(:,l,j)=S_temp(:,l,j)*2*(str2num(s(l))-0.5);
                end
                if squeeze(sum(sum(S_temp(:,:,j))))>maxs
                    maxs=squeeze(sum(sum(S_temp(:,:,j))));
                    maxi=i;
                end
            end
            i=maxi;
            s=dec2bin(i,m);
            for l=1:m
                S(l,:,j)=S(l,:,j)*2*(str2num(s(l))-0.5);
                S(:,l,j)=S(:,l,j)*2*(str2num(s(l))-0.5);
                Y{l}(:,j)=Y{l}(:,j)*2*(str2num(s(l))-0.5);
            end
        end
        %Correct order of dimensions
        sumS=squeeze(sum(sum(abs(S),1),2));
        [sumS,dimOrder]=sort(-sumS);
        Yt=Y;        
        for l=1:p
            for j=1:m
                Yt{j}(:,dimOrder(l))=Y{j}(:,l);
                S_temp(:,:,dimOrder(l))=S(:,:,l);
            end
        end
        Y=Yt;
        S=S_temp;       
        %Invert signs if necessary, so that first category of first variable
        %has positive quantifications
        for l=1:p
            if Y{1}(1,l)<0
                for j=1:m
                    Y{j}(:,l)=-Y{j}(:,l);
                end
            end
        end
    elseif model==5
        S=diag(Z(index:index+p-1));
        sumQj=0;
        for j=1:m
            sumQj=sumQj+(G{j}*Y{j})'*(G{j}*Y{j});
        end
        for l=1:p
            S(l,l)=S(l,l)*(sumQj(l,l)/(n*m));
            for j=1:m
                Y{j}(:,l)=Y{j}(:,l)/sqrt(sumQj(l,l)/(n*m));
            end
        end
        %Correct order of dimensions
        sumS=diag(abs(S));
        [sumS,dimOrder]=sort(-sumS);
        Yt=Y;
        S_temp=S;
        for l=1:p
            for j=1:m
                Yt{j}(:,dimOrder(l))=Y{j}(:,l);
                S_temp(dimOrder(l),dimOrder(l))=S(l,l);
            end
        end
        Y=Yt;
        S=S_temp;
    elseif model==6
        if p>1
            %Set rotation constraints
            YtY=zeros(p);
            for i=1:m
                YtY=YtY+(G{i}*Y{i})'*(G{i}*Y{i});
            end
            [Q,D]=eig(YtY);
            for i=1:m
                Y{i}=(inv(Q)*Y{i}')';
            end
            YtY=zeros(p);
            for i=1:m
                YtY=YtY+(G{i}*Y{i})'*(G{i}*Y{i});
            end
            %Re-order dimensions
            sumQj=0;
            for j=1:m
                sumQj=sumQj+(G{j}*Y{j})'*(G{j}*Y{j});
            end
            [sumQj,dimOrder]=sort(diag(-sumQj));
            Yt=Y;
            for l=1:p
                for j=1:m
                    Yt{j}(:,dimOrder(l))=Y{j}(:,l);
                end
            end
            Y=Yt;
        end
        %Invert signs if necessary, so that first category of first variable
        %has positive quantifications
        for l=1:p
            if Y{1}(1,l)<0
                for j=1:m
                    Y{j}(:,l)=-Y{j}(:,l);
                end
            end
        end
    end
end
Results.Y=Y;
Results.c=c;
Results.MainEffects=MainEffects;
Results.Deviance=devValue;
if model==2 || model==3 || model==4 || model==5
    Results.S=S;
end